# UI Principles

## Design Philosophy

UI follows brutalist web design principles with text-first, minimalist aesthetics inspired by HackerNews. The goal is clarity and functionality over visual decoration.

## Key Principles

1. **Text-Based**: Prioritize readable, semantic text. Minimize icons and visual noise.
2. **Brutalist**: Simple layouts, no gradients, no shadows, no unnecessary effects.
3. **Lightweight**: Fast loading, minimal HTTP requests, resource-efficient.
4. **Accessible**: Semantic HTML, proper contrast, keyboard navigable.

## Technical Stack

- **HTML**: Semantic, server-rendered templates
- **JavaScript**: Alpine.js from CDN (no build step required)
- **CSS**: Single stylesheet with class-based utilities and components
- **No dependencies**: Custom CSS only, no framework bloat

## Typography & Layout

- Clean monospace fonts for code/data
- Generous whitespace for readability
- Centered container layout (similar to HN)
- Minimal color palette (black, white, grays)

## Navigation

- Simple header with logo/title
- Flat navigation structure
- Breadcrumbs for context
- No dropdown menus

## Components

- Text inputs for entity analysis
- Results displayed in tables/lists
- Minimal buttons with borders only
- Loading states via simple spinners

## Alpine.js Usage

- Form handling and validation
- Dynamic list rendering
- Loading/error states
- Minimal interactivity, progressive enhancement

### Gotcha: Reactive Object Bindings

When using `:disabled` with dynamically added object properties (e.g., `loadingPhase[id]`), Alpine's Proxy wrapper can cause `undefined` to evaluate as truthy in attribute bindings. Always use explicit boolean checks: `:disabled="value === true"` instead of `:disabled="value"`.
