<script>
    import Toc from "@/components/Toc.svelte";
    import CodeBlock from "@/components/CodeBlock.svelte";
    import Accordion from "@/components/Accordion.svelte";
    import HeadingLink from "@/components/HeadingLink.svelte";
    import eventHooks from "../event_hooks.js";
</script>

<p>
    The standard way to modify PocketBase is through
    <strong>event hooks</strong> in your Go code.
</p>
<p>All hooks have 3 main methods:</p>
<ul>
    <li class="m-b-xs">
        <a
            href="{import.meta.env.PB_GODOC_URL}/tools/hook#Hook.Bind"
            target="_blank"
            rel="noopener noreferrer"
        >
            <code class="txt-bold">Bind(handler)</code>
        </a>
        adds a new handler to the specified event hook. A handler has 3 fields:
        <ul>
            <li>
                <code>Id</code> <em class="txt-hint">(optional)</em> - the name of the handler (could be used
                as argument for <code>Unbind</code>)
            </li>
            <li>
                <code>Priority</code> <em class="txt-hint">(optional)</em> - the execution order of the handler
                (if empty fallbacks to the order of registration in the code).
            </li>
            <li><code>Func</code> <em>(required)</em> - the handler function.</li>
        </ul>
    </li>
    <li class="m-b-xs">
        <a
            href="{import.meta.env.PB_GODOC_URL}/tools/hook#Hook.BindFunc"
            target="_blank"
            rel="noopener noreferrer"
        >
            <code class="txt-bold">BindFunc(func)</code>
        </a>
        is similar to <code>Bind</code> but registers a new handler from just the provided function.
        <br />
        The registered handler is added with a default 0 priority and the id is autogenerated (the returned string
        value).
    </li>
    <li>
        <a
            href="{import.meta.env.PB_GODOC_URL}/tools/hook#Hook.Trigger"
            target="_blank"
            rel="noopener noreferrer"
        >
            <code class="txt-bold">Trigger(event, oneOffHandlerFuncs...)</code>
        </a>
        triggers the event hook.
        <br />
        <em class="txt-hint">This method rarely has to be called manually by users.</em>
    </li>
</ul>

<p>
    To remove an already registered hook handler, you can use the handler id and pass it to
    <code>Unbind(id)</code> or remove all handlers with
    <code>UnbindAll()</code> (<em>!including system handlers</em>).
</p>

<div class="alert alert-info m-t-sm m-b-sm">
    <div class="icon">
        <i class="ri-information-line" />
    </div>
    <div class="content">
        <p>
            All hook handler functions share the same <code>{`func(e T) error`}</code> signature and expect
            the user to call <code>e.Next()</code> if they want to proceed with the execution chain.
        </p>
        <p class="txt-bold">
            If you need to access the app instance from inside a hook handler, prefer using the
            <code>e.App</code> field instead of reusing a parent scope app variable because the hook could be part
            of a DB transaction and can cause deadlock.
        </p>
        <p>
            Also avoid using global mutex locks inside a hook handler because it could be invoked recursively
            (e.g. cascade delete) and can cause deadlock.
        </p>
    </div>
</div>

<p>You can explore all available hooks below:</p>

<Toc headingSelector="h1, h2, h3, h4, h5" />

{#each eventHooks as group}
    <HeadingLink title={group.title} tag={group.tag || "h3"} />

    {#if group.description}{@html group.description}{/if}

    {#if group.hooks}
        <div class="accordions">
            {#each Object.entries(group.hooks) as [hookTitle, hookInfo]}
                {#if hookInfo.go}
                    <Accordion single title={hookTitle}>
                        <div class="content m-b-sm">{@html hookInfo.html}</div>
                        <CodeBlock language="go" class="m-b-0" content={hookInfo.go} />
                    </Accordion>
                {/if}
            {/each}
        </div>
    {/if}
{/each}
