package fetcher

import "fmt"

var registry = make(map[string]Fetcher)

// Register adds a fetcher to the global registry.
func Register(f Fetcher) {
	registry[f.Name()] = f
}

// Get retrieves a fetcher by name.
func Get(name string) (Fetcher, error) {
	f, ok := registry[name]
	if !ok {
		return nil, fmt.Errorf("fetcher not found: %s", name)
	}
	return f, nil
}

// Names returns all registered fetcher names.
func Names() []string {
	names := make([]string, 0, len(registry))
	for name := range registry {
		names = append(names, name)
	}
	return names
}
