package direct_access

import (
	"clio/internal/fetcher"
	"clio/internal/processor"
	"fmt"

	fetchedfilepb "clio/internal/fetched_file/pocketbase"
)

type DirectAccess struct{}

func init() {
	fetcher.Register(&DirectAccess{})
}

func (d *DirectAccess) Name() string {
	return "direct_access"
}

func (d *DirectAccess) Phases() []fetcher.PhaseDefinition {
	return []fetcher.PhaseDefinition{
		{
			Name:         "fetch",
			Dependencies: []string{}, // No dependencies
		},
	}
}

func (d *DirectAccess) GetExecutor(phaseName string, store *fetchedfilepb.Store) (processor.ExecutorFunc, error) {
	switch phaseName {
	case "fetch":
		return makeFetchExecutor(store), nil
	default:
		return nil, fmt.Errorf("unknown phase: %s", phaseName)
	}
}
