package fetcher_router

import (
	"time"
)

// FetcherRouter represents a domain-to-fetcher routing configuration.
type FetcherRouter struct {
	ID            string                 `json:"id" db:"id"`
	Domain        string                 `json:"domain" db:"domain"`
	Fetcher       string                 `json:"fetcher" db:"fetcher"` // youtube_downloader, nytime_searcher, archive_proxy
	FetcherConfig map[string]any `json:"fetcher_config" db:"fetcher_config"`
	Created       time.Time              `json:"created" db:"created"`
	Updated       time.Time              `json:"updated" db:"updated"`
}
