package link

import (
	"time"
)

// Link represents a link processing record.
// It implements processor.Record interface.
type Link struct {
	ID              string                 `json:"id" db:"id"`
	InitialURL      string                 `json:"initial_url" db:"initial_url"`
	Status          string                 `json:"status" db:"status"` // pending, processing, completed, failed
	CurrentPhase    *string                `json:"current_phase" db:"current_phase"`
	CompletedPhases []string               `json:"completed_phases" db:"completed_phases"`
	PhaseResults    map[string]interface{} `json:"phase_results" db:"phase_results"`
	ErrorMessage    *string                `json:"error_message" db:"error_message"`
	Created         time.Time              `json:"created" db:"created"`
	Updated         time.Time              `json:"updated" db:"updated"`
}

// GetID implements processor.Record.
func (l *Link) GetID() string {
	return l.ID
}

// GetStatus implements processor.Record.
func (l *Link) GetStatus() string {
	return l.Status
}

// SetStatus implements processor.Record.
func (l *Link) SetStatus(status string) {
	l.Status = status
}

// GetCurrentPhase implements processor.Record.
func (l *Link) GetCurrentPhase() *string {
	return l.CurrentPhase
}

// SetCurrentPhase implements processor.Record.
func (l *Link) SetCurrentPhase(phase *string) {
	l.CurrentPhase = phase
}

// GetCompletedPhases implements processor.Record.
func (l *Link) GetCompletedPhases() []string {
	if l.CompletedPhases == nil {
		return []string{}
	}
	return l.CompletedPhases
}

// AddCompletedPhase implements processor.Record.
func (l *Link) AddCompletedPhase(phase string) {
	if l.CompletedPhases == nil {
		l.CompletedPhases = []string{}
	}
	l.CompletedPhases = append(l.CompletedPhases, phase)
}

// GetPhaseResults implements processor.Record.
func (l *Link) GetPhaseResults() map[string]interface{} {
	if l.PhaseResults == nil {
		return make(map[string]interface{})
	}
	return l.PhaseResults
}

// SetPhaseResults implements processor.Record.
func (l *Link) SetPhaseResults(results map[string]interface{}) {
	l.PhaseResults = results
}

// GetErrorMessage implements processor.Record.
func (l *Link) GetErrorMessage() *string {
	return l.ErrorMessage
}

// SetErrorMessage implements processor.Record.
func (l *Link) SetErrorMessage(msg string) {
	l.ErrorMessage = &msg
}
