package pocketbase

import (
	"clio/internal/processor"

	// Import all fetchers so they self-register
	_ "clio/internal/fetcher/direct_access"

	"github.com/pocketbase/pocketbase/core"
)

// Setup initializes the processor for link management.
// Returns orchestrator and API ready to use.
func Setup(app core.App) (*processor.Orchestrator, *processor.API) {
	// Create PocketBase store
	store := New(app)

	// Create orchestrator
	orch := processor.New(store)

	// Create executor registry
	execs := processor.NewExecutorRegistry()

	// Register phases
	RegisterRouteFetcherPhase(orch, execs, app)

	// Set execution order
	orch.SetOrder([]string{"route_fetcher"})

	// Create API
	api := processor.NewAPI(orch, execs)

	return orch, api
}
