package processor

// Record is the abstraction for any entity that goes through phase processing.
// Implement this interface for any table that needs phase management.
type Record interface {
	// GetID returns the record's unique identifier
	GetID() string

	// GetStatus returns the current status (pending/processing/completed/failed)
	GetStatus() string
	SetStatus(string)

	// GetCurrentPhase returns the active phase name
	GetCurrentPhase() *string
	SetCurrentPhase(*string)

	// GetCompletedPhases returns the list of completed phase names
	GetCompletedPhases() []string
	AddCompletedPhase(string)

	// GetPhaseResults returns the map of phase outputs
	GetPhaseResults() map[string]interface{}
	SetPhaseResults(map[string]interface{})

	// GetErrorMessage returns the failure reason (if any)
	GetErrorMessage() *string
	SetErrorMessage(string)
}
