package migrations

import (
	"github.com/pocketbase/pocketbase/core"
	m "github.com/pocketbase/pocketbase/migrations"
)

func init() {
	m.Register(func(app core.App) error {
		collection, err := app.FindCollectionByNameOrId("pbc_1691694954")
		if err != nil {
			return err
		}

		// update field
		if err := collection.Fields.AddMarshaledJSONAt(2, []byte(`{
			"hidden": false,
			"id": "select3904320448",
			"maxSelect": 1,
			"name": "fetcher",
			"presentable": false,
			"required": false,
			"system": false,
			"type": "select",
			"values": [
				"youtube_downloader",
				"nytime_searcher",
				"archive_proxy"
			]
		}`)); err != nil {
			return err
		}

		return app.Save(collection)
	}, func(app core.App) error {
		collection, err := app.FindCollectionByNameOrId("pbc_1691694954")
		if err != nil {
			return err
		}

		// update field
		if err := collection.Fields.AddMarshaledJSONAt(2, []byte(`{
			"hidden": false,
			"id": "select3904320448",
			"maxSelect": 1,
			"name": "fetcher",
			"presentable": false,
			"required": false,
			"system": false,
			"type": "select",
			"values": [
				"youtube_downloader",
				"nytime_searcher",
				"archive_proxy",
				"direct_access"
			]
		}`)); err != nil {
			return err
		}

		return app.Save(collection)
	})
}
