
# light python 3.10
FROM python:3.10.0

WORKDIR /home

# install python dependencies
COPY py_opt_utils/requirements.txt .
RUN pip install -r requirements.txt

# copy python files
COPY py_opt_utils/ ./py_opt_utils/
COPY server.py .

# expose port
EXPOSE 8000

# run server
CMD ["uvicorn", "server:app", "--host", "127.0.0.1", "--port", "8000"]
