
DESC="
# create a backup usig docker shared volumes
# so, it needs the running server / the nnp folder
# if _prod exists on server then
#    - stop service
#    - save the state (but doesnt remove from folder)
#    - delete the folder
#    - delete docker images
#
# can be undo with unarchive.sh
--------------
"

PROD_FOLDER=nnp
SSH_PEM=~/aws/k_nnp_main.pem
LAST_STATE_FOLDER=last_state/
DOCKER_COMPOSE_FILE=docker-compose-deploy.yml

DOCKERDOWN="sudo docker compose -f $DOCKER_COMPOSE_FILE down"
DOCKERUP="sudo docker compose -f $DOCKER_COMPOSE_FILE up -d"
CANDO="sudo chmod 760 -R"
CURRDATE=$(date +"%Y-%m-%d")


#echo "$DESC"
echo "BACKUP DATA"

# check if nnp exists
PROD_EXISTS=""
ssh ubuntu@nonoiseplease.com -i $SSH_PEM    "test -d $PROD_FOLDER"
PROD_EXISTS=`echo $?` # 1 if missing, 0 if exists
if [ $PROD_EXISTS -eq 1 ]; then
    echo " No $PROD_FOLDER folder on server, QUITTING"
    exit 1
else
    echo " $PROD_FOLDER folder exists, can continue"
fi




echo " saving state"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "sudo rm -rf $LAST_STATE_FOLDER"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "mkdir $LAST_STATE_FOLDER"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "sudo cp -r $PROD_FOLDER/pb_data $LAST_STATE_FOLDER"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "sudo cp -r $PROD_FOLDER/logs $LAST_STATE_FOLDER"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "sudo cp -r $PROD_FOLDER/meili_data $LAST_STATE_FOLDER"

# compress and version older service
echo " creating backup"
ssh ubuntu@nonoiseplease.com -i $SSH_PEM "sudo tar -czvf PROD_BCK_${CURRDATE}.tar.gz $PROD_FOLDER" 1> /dev/null

