
DESC="
# IDEMPOWENT SCRIPT
# creates a prod folder with the latest version of the service
# ready to be sent to the server
# typically: build -> archiever -> deploy_rem
# or: build -> move_to_aws -> kill_tutto -> deploy_rem
--------------
"

ENV_FOLDER="nnp"
EXE_NAME="bedocker"
CONF_NAME="config.yml"
PUBLIC_FOLDER="pb_public"
CONTAINING_BE_FOLDER="backend"
DOCKERFILE="pbprd.Dockerfile"
STATE_LOG_FLODER="logs"
STATE_DATA_FOLDER="pb_data"
MEILIFOLDER="meili_data"
DOCKER_COMPOSE_FILE="docker-compose-deploy.yml"


echo "$DESC"

# 1 check if prod folder exists
if [ -d "$ENV_FOLDER" ]; then
    echo "1 prod folder exists removing everything inside"
    rm -rf $ENV_FOLDER/*
else
    echo "1 prod folder does not exist"
    mkdir $ENV_FOLDER
fi



# 3 moving backend
echo "3 moving backend"
cp -r $CONTAINING_BE_FOLDER/$PUBLIC_FOLDER $ENV_FOLDER/$PUBLIC_FOLDER
cp -r $CONTAINING_BE_FOLDER/$EXE_NAME      $ENV_FOLDER/$EXE_NAME
cp -r $CONTAINING_BE_FOLDER/$CONF_NAME     $ENV_FOLDER/$CONF_NAME
cp -r $CONTAINING_BE_FOLDER/$DOCKERFILE    $ENV_FOLDER/$DOCKERFILE


# 4 remove state from backend
echo "4 removing state from backend"
rm -rf $ENV_FOLDER/$BE_FOLDER/$STATE_LOG_FLODER
rm -rf $ENV_FOLDER/$BE_FOLDER/$STATE_DATA_FOLDER

echo "5 actually they just has to be empty, so make en empty folder"
mkdir $ENV_FOLDER/$STATE_LOG_FLODER
mkdir $ENV_FOLDER/$STATE_DATA_FOLDER
mkdir $ENV_FOLDER/$MEILIFOLDER

# 7 copy docker
echo "7 copying docker"
cp $DOCKER_COMPOSE_FILE $ENV_FOLDER/





