

DESC="
# restore state of archieved service
# if _prod exists on server then
#    - exit
# else
#    - unzip the last state (the one with greater date)
#    - start service
--------------
"

PROD_FOLDER=nnp
SSH_PEM=~/aws/k_nnp_main.pem
LAST_STATE_FOLDER=last_state/
DOCKER_COMPOSE_FILE=docker-compose-deploy.yml

DOCKERDOWN="sudo docker compose -f $DOCKER_COMPOSE_FILE down"
DOCKERUP="sudo docker compose -f $DOCKER_COMPOSE_FILE up -d"

# echo "$DESC"

# check if _prod exists
PROD_EXISTS=""
ssh ubuntu@palladineve.com -i $SSH_PEM "test -d $PROD_FOLDER"
PROD_EXISTS=`echo $?` # 1 if missing, 0 if exists

if [ $PROD_EXISTS -eq 1 ]; then
    echo "No $PROD_FOLDER folder on server, OK restore state"
    # find PROD_BCK_ created the latest
    LATEST_ARCHIVE=$(ssh ubuntu@palladineve.com -i $SSH_PEM "ls -t | grep PROD_BCK_ | head -1")
    # restore state
    echo "restoring state from $LATEST_ARCHIVE"
    ssh ubuntu@palladineve.com -i $SSH_PEM "tar -xzvf $LATEST_ARCHIVE" 1> /dev/null
    echo "removing $LATEST_ARCHIVE"
    ssh ubuntu@palladineve.com -i $SSH_PEM "rm $LATEST_ARCHIVE"
    echo "starting service"
    ssh ubuntu@palladineve.com -i $SSH_PEM "cd $PROD_FOLDER && $DOCKERUP" 2>/dev/null

else
    echo "prod folder exists"
    echo "service probably running"
    exit 1
fi


